<?php
/*
  {{NewStyle aliasedName=realStyle[, newAlias=style[, ...]]}}
  {{FormatAs %%=pascal[, !!=warning[, ...]]}}
  {{FormatAs mirror=html}}        - for example: %%(mirror)\n <html attr="val">\n %%
*/

class Unewstyle_Root extends UWikiBaseAction {
  public $runsImmediately = true;

  function Execute($format, $params) {
    foreach ($params as $aliasTo => $style) {
      $format->origDoc->settings->styleAliases[ mb_strtolower($aliasTo) ] = mb_strtolower($style);
    }
  }
}

  class Uformatas_Root extends Unewstyle_Root {
    function Execute($format, $params) {
      foreach ($params as $token => $style) {
          $style = mb_strtolower($style);

        $elementNames = &$this->settings->elementTokens[$token];
        $elementNames === null and $elementNames = array($this->RealStyleBy($token).'_Root');

        foreach ($elementNames as $name) {
          $format->origDoc->settings->styleAliases[$name] = $style;
        }
      }
    }
  }
